/* Revision Control

$Header: C:\\RCS\\d\\saldvl\\noteview\\scorevc\\grphclrp\\grphclob\\grpbstat.cpp,v 1.3 2002-08-29 11:49:54+02 renz Exp $ 

$Id: grpbstat.cpp,v 1.3 2002-08-29 11:49:54+02 renz Exp $ 

$Log: grpbstat.cpp,v $
Revision 1.3  2002-08-29 11:49:54+02  renz
Added RCS Headers
Now using GRSpaceForceFunction2 ...
 

$Author: renz $ 

$Date: 2002-08-29 11:49:54+02 $ 

$Locker:  $ 

$Revision: 1.3 $ 

$Name:  $ 

$RCSfile: grpbstat.cpp,v $ 

$Source: C:\\RCS\\d\\saldvl\\noteview\\scorevc\\grphclrp\\grphclob\\grpbstat.cpp,v $ 

*/


#include "GRPBStat.h"
#include "GrphclRp\GrphclOb\GRVcMngr.h"
#include "GrphclRp\GrphclOb\GRStafMg.h"
#include "GrphclRp\GrphclOb\GRVoice.h"
#include "GrphclRp\GrphclOb\GRPTag.h"
#include "GrphclRp\GrphclOb\GRSystem.h"

GRPossibleBreakState::GRPossibleBreakState()
{
	// owns elements!
	ssvect = new KF_IVector<GRStaffAndState>(1);
	vtsvect = new KF_IVector<GRVoiceTagsAndStaff>(1);
#ifdef OLDSPFACTIVE
	spf = NULL;
	copyofcompletespf = NULL;
#endif
	sff = NULL;
	copyofcompletesff = NULL;
	lastrod = NULL;
	firstrod = NULL;
}

GRPossibleBreakState::~GRPossibleBreakState()
{
	delete ssvect;
	delete vtsvect;

#ifdef OLDSPFACTIVE
	if (spf)
		delete spf;
	if (copyofcompletespf)
		delete copyofcompletespf;
#endif

	if (sff)
		delete sff;
	if (copyofcompletesff)
		delete copyofcompletesff;
}

void GRPossibleBreakState::SaveState(KF_IVector<GRStaff> *vstaffs,
		KF_IVector<GRVoiceManager> *vvcemgrs,
		GRStaffManager *staffmgr,
		const TYPE_TIMEPOSITION &curtp,
		float parforce,
		float breakval)
{
	// this saves the staff-stuff
  int i;
	for (i=vstaffs->GetMinimum();i<=vstaffs->GetMaximum();i++)
	{
		GRStaff *staff = vstaffs->Get(i);
		if (staff)
		{
			GRStaffAndState *sas = new GRStaffAndState();
			sas->pstaff = staff;
			sas->setLastRod(staff->lastrod);
			sas->setFirstRod(staff->firstrod);
			sas->tpos = staff->elements->GetTailPosition();
			sas->staffstate = staff->getGRStaffState();
			ssvect->Set(i,sas);
		}
	}

	// now the voice-mgr-stuff ...
	// (grtags ...)
	for (i = vvcemgrs->GetMinimum();i<=vvcemgrs->GetMaximum();i++)
	{
		GRVoiceManager * vcmgr = 
			vvcemgrs->Get(i);
		if (vcmgr)
		{
			GRVoiceTagsAndStaff * vts = 
				new GRVoiceTagsAndStaff(vcmgr);
			vts->SaveGRTags(vcmgr->grtags);
			vts->setLastRod(vcmgr->getGRVoice()->getLastRod());
			vts->setFirstRod(vcmgr->getGRVoice()->getFirstRod());
			vts->pstaff = vcmgr->curstaff;
			vts->staffnum = vcmgr->staffnum;
			vtsvect->Set(i,vts);
		}
	}

	// now for the staffmgr (springID, positions
	// for rod-lists ...)
	springID = staffmgr->springID;
	simplerodspos = staffmgr->simplerods->GetTailPosition();
	complexrodspos = staffmgr->complexrods->GetTailPosition();


	// and now for the system ... the position of 
	// the last system-element ....
	
	// systemelementendpos = staffmgr->grsystem->GetTailPosition();

	// the timeposition
	tp = curtp;

	force = parforce;

	pbreakval = breakval;

	lastrod = staffmgr->lastrod;
	firstrod = staffmgr->firstrod;
}


void GRPossibleBreakState::GRVoiceTagsAndStaff::SaveGRTags(KF_IPointerList<GRTag> *input)
{
	// the list owns the GRTagAndPosition
	grtags = new KF_IPointerList<GRTagAndPosition>(1);

	POSITION pos = input->GetHeadPosition();
	while (pos)
	{
		GRTag *grtag = input->GetNext(pos);
		GRTagAndPosition * grtp = new
			GRTagAndPosition;
		grtp->grtag = grtag;
		GRNotationElement *el =
			dynamic_cast<GRNotationElement *>(grtag);
		if (el)
		{
			if (el->getAssociations())
				grtp->assocpos = el->getAssociations()->GetTailPosition();
			else
				grtp->assocpos = NULL;
		}
		else
			grtp->assocpos = NULL;
		grtags->AddTail(grtp);
	}

}

// this routine is called, to signal
// a break at this saved position.
// It calls the respective functions
// for all saved grtags (including
// the assocpos)
void GRPossibleBreakState::GRVoiceTagsAndStaff::EndAtBreak()
{

	POSITION pos = grtags->GetHeadPosition();
	while (pos)
	{
		GRTagAndPosition *tp = grtags->GetNext(pos);
		// increments tp->assocpos!
		// (so that it can be used
		//  in BeginAfterBreak to correctly
		// set the assocpos).
		ASSERT(tp);
		GRPositionTag *grpt = dynamic_cast<GRPositionTag *>(tp->grtag);
		if (grpt)
			grpt->BreakTag(pstaff,tp->assocpos);
	}

}

// this routine is called, when the new staff has
// been created and we need to resume the tags ...
// addpos is the position within the staff, where the
// open-tags should be (can be) added.
void GRPossibleBreakState::GRVoiceTagsAndStaff::BeginAfterBreak(GRStaff *newstaff,
											POSITION addpos)
{
	POSITION pos = grtags->GetHeadPosition();
	while (pos)
	{
		GRTagAndPosition *tp = grtags->GetNext(pos);
		GRPositionTag *grpt = dynamic_cast<GRPositionTag *>(tp->grtag);
		if (grpt)
			grpt->ResumeTag(newstaff,tp->assocpos);
	
		// add the tag to the new tag to the staff ...
		// this must be at the correct position though! 
		GRNotationElement *el = dynamic_cast<GRNotationElement *>(tp->grtag);
		if (el && newstaff)
		{
			if (addpos)
				newstaff->AddElementAt(addpos,el);
			else
				newstaff->AddTail(el);
		}
	}


}

// this routine changes all inlying staff-pointers
// so that they belong to new staves ...
void GRPossibleBreakState::ChangeStaffPointers(KF_IVector<GRStaff> *newstaves,
							GRPossibleBreakState *oldpbs)
{

  int i;
	for (i=ssvect->GetMinimum();i<=ssvect->GetMaximum();i++)
	{
		GRStaffAndState *sas = ssvect->Get(i);
		if (!sas) continue;
		ASSERT(sas);
		// this is easy, because the staves
		// are still numbered...
		sas->pstaff = newstaves->Get(i);

		if (oldpbs && oldpbs->ssvect)
		{
			GRStaffAndState *oldsas = oldpbs->ssvect->Get(i);
			if (oldsas)
			{
				if (oldsas->tpos == NULL)
				{
					sas->tpos = sas->pstaff->elements->GetTailPosition();
				}
			}
		}
	}

	for (i=vtsvect->GetMinimum();i<=vtsvect->GetMaximum();i++)
	{
		GRVoiceTagsAndStaff *vts = vtsvect->Get(i);
		ASSERT(vts);
		// this relies heavily on STAFFNUM!
		vts->pstaff = newstaves->Get(vts->grvoicemgr->getStaffNum());
	}
}
